/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.action;

import de.willuhn.jameica.bookmark.Bookmark;
import de.willuhn.jameica.bookmark.BookmarkService;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;

public class BookmarkDelete
implements Action {
    private Bookmark bookmark = null;

    public BookmarkDelete() {
    }

    public BookmarkDelete(Bookmark bookmark) {
        this.bookmark = bookmark;
    }

    @Override
    public void handleAction(Object context) throws ApplicationException {
        if (context instanceof Bookmark) {
            this.bookmark = (Bookmark)context;
        }
        if (this.bookmark == null) {
            throw new ApplicationException(Application.getI18n().tr("Bitte w\u00e4hlen Sie das zu l\u00f6schende Lesezeichen"));
        }
        try {
            if (!Application.getCallback().askUser(Application.getI18n().tr("Lesezeichen l\u00f6schen?"))) {
                throw new OperationCanceledException();
            }
            BeanService beanService = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            BookmarkService bs = beanService.get(BookmarkService.class);
            bs.delete(this.bookmark);
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (OperationCanceledException oce) {
            throw oce;
        }
        catch (Exception e) {
            Logger.error((String)"unable to delete bookmark", (Throwable)e);
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("L\u00f6schen des Lesezeichens fehlgeschlagen: {0}", e.getMessage()), 1));
        }
    }
}

